package se.kth.anderslm.discovery;

import java.util.ArrayList;

import android.os.Bundle;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.view.Menu;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

/**
 * This application demonstrates how to discover BT devices and how to make this
 * device "discoverable" to other devices.
 */
public class MainActivity extends Activity {

	public static final int REQUEST_ENABLE = 1;
	public static final int REQUEST_DISCOVERABLE = 2;

	private BluetoothAdapter bluetoothAdapter;
	private BroadcastReceiver discoveryReceiver;

	private ArrayList<BluetoothDevice> remoteDevices;
	private ArrayAdapter<BluetoothDevice> arrayAdapter;
	private ListView listView;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.activity_main);
		remoteDevices = new ArrayList<BluetoothDevice>();
		arrayAdapter = new BTDeviceArrayAdapter(this, remoteDevices);
		listView = (ListView) findViewById(R.id.listView);
		listView.setAdapter(arrayAdapter);

		bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
		discoveryReceiver = new BTDiscoveryReceiver(bluetoothAdapter,
				remoteDevices, arrayAdapter);
	}

	@Override
	protected void onStop() {
		super.onStop();
		// NB!
		bluetoothAdapter.cancelDiscovery();
		unregisterReceiver(discoveryReceiver);
	}

	// call back when setting device in mode discoverable
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (requestCode == REQUEST_DISCOVERABLE) {
			if (resultCode > 0) { // seconds discoverable
				showToast("Your device will be discoverable for " + resultCode
						+ " seconds");
			} else {
				showToast("Your device is not discoverable");
			}
		}
	}

	public void onDiscoverabilityClicked(View view) {
		Intent disc = new Intent(BluetoothAdapter.ACTION_REQUEST_DISCOVERABLE);
		startActivityForResult(disc, REQUEST_DISCOVERABLE);
	}

	public void onSeachClick(View view) {
		registerReceiver(discoveryReceiver, new IntentFilter(
				BluetoothDevice.ACTION_FOUND));

		if (!bluetoothAdapter.isDiscovering()) {
			remoteDevices.clear();
			bluetoothAdapter.startDiscovery();
		}
	}

	private void showToast(String msg) {
		Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
		toast.show();
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
}
