package se.kth.anderslm.discovery;

import java.util.List;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.widget.ArrayAdapter;

class BTDiscoveryReceiver extends BroadcastReceiver {

	BTDiscoveryReceiver(final BluetoothAdapter btAdapter,
			final List<BluetoothDevice> deviceList,
			final ArrayAdapter<BluetoothDevice> arrayAdapter) {
		this.btAdapter = btAdapter;
		this.deviceList = deviceList;
		this.arrayAdapter = arrayAdapter;

	}

	@Override
	public void onReceive(Context context, Intent intent) {
		BluetoothDevice remoteDevice;
		remoteDevice = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
		if (!btAdapter.getBondedDevices().contains(remoteDevice)) {
			deviceList.add(remoteDevice);
			arrayAdapter.notifyDataSetChanged();
		}
	}

	private final BluetoothAdapter btAdapter;
	private final List<BluetoothDevice> deviceList;
	private final ArrayAdapter<BluetoothDevice> arrayAdapter;
}
