package se.kth.anderslm.discovery;

import java.util.List;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

class BTDeviceArrayAdapter extends ArrayAdapter<BluetoothDevice> {

	public BTDeviceArrayAdapter(Context context, List<BluetoothDevice> deviceList) {
		super(context, R.layout.device_item_layout, deviceList);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		LayoutInflater inflater = (LayoutInflater) getContext()
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View rowView = inflater.inflate(R.layout.device_item_layout, parent,
				false);
		
		TextView nameView = (TextView) rowView.findViewById(R.id.deviceName);
		TextView infoView = (TextView) rowView.findViewById(R.id.deviceInfo);
		BluetoothDevice device = this.getItem(position);
		nameView.setText(device.getName());
		infoView.setText(device.getBluetoothClass() + ", " + device.getAddress());

		return rowView;
	}
}
