package se.kth.anderslm.pullparser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class RSSParser {

	public static final String TITLE = "title";
	public static final String DESCRIPTION = "description";
	public static final String LINK = "link";
	public static final String ITEM = "item";
	public static final String PUBDATE = "pubDate";
	
	private XmlPullParser parser;
	private ArrayList<String> itemList;
	
	public RSSParser() throws XmlPullParserException {	
		parser = XmlPullParserFactory.newInstance().newPullParser();
	}
	
	public void parse(InputStream xmlStream, ArrayList<String> itemList) throws Exception {
		parser.setInput(xmlStream, null);
		this.itemList = itemList;
		
		int parseEvent = parser.getEventType();
		
		while(parseEvent != XmlPullParser.END_DOCUMENT) {
			switch(parseEvent) {
			case XmlPullParser.START_DOCUMENT:
				//
				break;
			case XmlPullParser.END_DOCUMENT:
				//
				break;
			case XmlPullParser.START_TAG:
				String tagName = parser.getName();
				if(tagName.equalsIgnoreCase(ITEM)) {
					parseItem();
				}
				break;
			case XmlPullParser.END_TAG:
				//
				break;
			case XmlPullParser.TEXT:
				//
				break;
			default:
				//
			}
			
			parseEvent = parser.next();
		}
	}
	
	/** 
	 * Handle this <item>-tag
	 */
	private void parseItem() throws IOException, XmlPullParserException {
		int parseEvent;
		String name, item = "";
		// Continue until end of </item>
		do {
			parseEvent = parser.next();
			name = parser.getName();
			if(parseEvent == XmlPullParser.START_TAG) {
				if(name.equalsIgnoreCase(TITLE)) {
					item += parser.nextText() + "\n";
				}
				else if(name.equalsIgnoreCase(PUBDATE)) {
					item += parser.nextText(); 	
				}
			}
		} while(parseEvent != XmlPullParser.END_TAG || !name.equals(ITEM));
		
		if(!name.equals("")) {
			itemList.add(item);
		}
	}
}
