package se.kth.anderslm.activitylifecycle;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.EditText;

/**
 * This class demonstrates when Activity state call backs are executed during
 * the activity's life cycle. Use Logcat to view the Log.i-messages. Compare
 * what methods are called when you press the the device's home button and back
 * button respectively. Restart the application through the device's list of
 * applications.
 */
public class MainActivity extends Activity {

	public static final String EDIT_TEXT_INPUT = "EDIT_TEXT_INPUT";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		Log.i("SaveActivity", "onCreate called");

		this.setContentView(R.layout.activity_main);
		inputText = (EditText) this.findViewById(R.id.InputText);
	}

	/**
	 * Restore UI state here.
	 */
	@Override
	protected void onRestoreInstanceState(Bundle inState) {
		super.onRestoreInstanceState(inState);
		Log.i("SaveActivity", "onRestoreInstanceState called");

		// Just an example, this is actually done by default on most View
		// objects.
		String input = inState.getString(EDIT_TEXT_INPUT);
		if (input != null)
			inputText.setText(input);
	}

	@Override
	protected void onStart() {
		super.onStart();
		Log.i("SaveActivity", "onStart called");
	}

	@Override
	protected void onResume() {
		super.onResume();
		Log.i("SaveActivity", "onResume called");
	}

	/**
	 * Save UI state here.
	 */
	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		Log.i("SaveActivity", "onSaveInstanceState called");

		// Just an example, this is actually done by default on most View
		// objects.
		String input = inputText.getText().toString();
		outState.putString(EDIT_TEXT_INPUT, input);
	}

	/**
	 * Save application state in onPause. After onPause has been called the
	 * application is "killable". Also, stop threads doing (unnecessary) work in
	 * the background (restart in onResume).
	 */
	@Override
	protected void onPause() {
		super.onPause();
		Log.i("SaveActivity", "onPause called");
	}

	@Override
	protected void onStop() {
		super.onStop();
		Log.i("SaveActivity", "onStop called");
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.i("SaveActivity", "onDestroy called");
	}

	private EditText inputText;
}