package se.kth.anderslm.spinnerandadapter;

import android.os.Bundle;
import android.app.Activity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.Toast;
import android.widget.AdapterView.OnItemSelectedListener;

public class MainActivity extends Activity {

	private Spinner spinner;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		spinner = (Spinner) findViewById(R.id.PetSpinner);

		// Create an array adapter associating the PETS array with the spinner
		// Set a basic layout for the spinner items
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_item, PETS);
		adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		spinner.setAdapter(adapter);

		spinner.setOnItemSelectedListener(new SpinnerListener());
	}

	private class SpinnerListener implements OnItemSelectedListener {
		public void onItemSelected(AdapterView<?> parent, View view, int pos,
				long id) {
			String pet = (String) spinner.getSelectedItem();
			showToast("Your favourite pet is a(n) " + pet);
		}

		public void onNothingSelected(AdapterView<?> parent) {
		}
	}

	private void showToast(String msg) {
		Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
		toast.show();
	}

	private static final String[] PETS = { "Ant", "Bee", "Cat", "Dog", "Eel",
			"Flea", "Giant Panda Bear", "Horse" };
}
