package se.kth.anderslm.service;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

/**
 * A simple example on a Service intended to run in the 
 * background. This Activity is used to launch and stop the
 * Service. If you start the service and finish this Activity,
 * the Service still is running. To stop the Service, restart
 * the Activity from the device's app menu and select stop.
 * 
 * All messages are log by Log.i; use Logcat to display output.
 */
public class ManageServiceActivity extends Activity {

	private Button startButton, stopButton;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		Log.i("Activity", "onCreate");

		setContentView(R.layout.main);
		startButton = (Button) findViewById(R.id.StartButton);
		stopButton = (Button) findViewById(R.id.StopButton);
		OnButtonClickListener listener = new OnButtonClickListener();
		startButton.setOnClickListener(listener);
		stopButton.setOnClickListener(listener);
	}

	public void onDestroy() {
		super.onDestroy();
		Log.i("Activity", "onDestroy");
	}

	// Called on start button click
	private void startExampleService() {
		Intent intent = new Intent(this, ExampleService.class);
		intent.putExtra("interval", 1000);
		startService(intent);
		Log.i("Activity", "startExampleService");
	}

	// Called on start button click
	private void stopExampleService() {
		Intent intent = new Intent(this, ExampleService.class);
		stopService(intent);
		Log.i("Activity", "stopExampleService");
	}

	private class OnButtonClickListener implements View.OnClickListener {
		public void onClick(View view) {
			if (view == startButton) {
				startExampleService();
			} 
			else if (view == stopButton) {
				stopExampleService();
			}
		}
	}
}
