package se.kth.anderlm.intents;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

public class MyOtherActivity extends Activity {
	
	private Button backButton;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i("IntentTest", "  OtherActivity.onCreate");
        
        setContentView(R.layout.other);
        
        backButton = (Button) findViewById(R.id.BackButton);
        backButton.setOnClickListener(new OnBackButtonClick());
    }
    
    private class OnBackButtonClick implements View.OnClickListener {

		public void onClick(View v) {
			Intent intent = new Intent(
					MyOtherActivity.this,
					MyMainActivity.class);
			startActivity(intent);
			finish();
		}
    }
    
    protected void onStart() {
    	super.onStart();
    	Log.i("IntentTest", "  OtherActivity.onStart");
    }
    
    protected void onResume() {
    	super.onStart();
    	Log.i("IntentTest", "  OtherActivity.onResume");
    }
    
    protected void onPause() {
    	super.onPause();
    	Log.i("IntentTest", "  OtherActivity.onPause");
    }
    
    protected void onStop() {
    	super.onStop();
    	Log.i("IntentTest", "  OtherActivity.onStop");
    }
    
    protected void onDestroy() {
    	super.onDestroy();
    	Log.i("IntentTest", "  OtherActivity.onDestroy");
    }
}
