package se.kth.anderslm.callbacks;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

/** Outputs information on when life cycle callback methods are called.
 *  
 */
public class ActLifeCycleCallBacksActivity extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        makeToast("onCreate");
        Log.v("Life cycle callback", "onCreate");
    }
    
    @Override
    protected void onStart() {
        super.onStart();
        
        makeToast("onStart");
        Log.v("Life cycle callback", "onStart");
    }
    
    @Override
    protected void onRestart() {
        super.onRestart();
        
        makeToast("onRestart");
        Log.v("Life cycle callback", "onRestart");
    }
    
    @Override
    protected void onResume() {
        super.onResume();
        
        makeToast("onResume");
        Log.v("Life cycle callback", "onResume");
    }
    
    @Override
    protected void onPause() {
        super.onPause();
        
        makeToast("onPause");
        Log.v("Life cycle callback", "onPause");
    }
    
    @Override
    protected void onStop() {
        super.onStop();
        
        makeToast("onStop");
        Log.v("Life cycle callback", "onStop");
    }
    
    @Override
    protected void onDestroy() {
        super.onDestroy();
        
        makeToast("onDestroy");
        Log.v("Life cycle callback", "onDestroy");
    }
    
    private void makeToast(CharSequence msg) {
    	Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
    	toast.show();
    }
}