#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>

int main(void) /* fork6.c */
{
  pid_t pid;
  pid = fork();

  switch(pid) {

    case -1: 
      fprintf(stderr,"fork failed"); 
      exit (1); 
  
    case 0: 
      printf("I am the child with pid = %d\n", 
        getpid());
      printf("My parent has pid = %d\n", getppid());
      sleep (1);
      exit(0);
      
    default:
      wait (0);
      printf("I am the parent, my child's pid = %d\n", 
        pid);
      printf("My pid = %d.\n\n", getpid());
  }
  return 0; //Endast föräldern gör detta anrop
}
