#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>

int main(void)
{
  pid_t pid;
  pid = fork();

  switch(pid)
  {
    case -1:
      fprintf(stderr,"fork failed");
      exit (1);
      break;

    case 0:
      printf("I am doing exit(), so I become a Zombie.\n");
      exit(0);

    default:
      printf("While I'm sleeping, my child [%d] is a Zombie.\n", pid);
      sleep(20);
      wait(0);
      printf("Now my child is a Zombie no more.\n");
      printf("But I'm back for some more sleep...\n");
      sleep(20);
  }
  return 0;
}
