#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>

int main(void)  /* fork7.c */
{
  pid_t pid;
  pid = fork();

  switch(pid) {
    case -1:
      fprintf(stderr,"fork failed");
      exit (1);

    case 0:
      printf("Child with pid = %d\n", getpid());
      printf("I'm running ls:\n");
      execl("/bin/ls", "ls", NULL);
      sleep (1);   //Fråga: kommer sleep att utföras?
      exit(0);

    default:
      wait (0);
      printf("Parent, my child's pid = %d\n", pid);
      printf("My pid = %d.\n\n", getpid());
  }
  return 0; //Endast föräldern gör detta anrop
}
