// file: Load.java
// How to deserialize objects from a file

import java.io.*;
import java.util.*;

public class Load {

    @SuppressWarnings("unchecked")
    public static void main(String[] args) throws Exception {

        ObjectInputStream ois = null;

        try {

            FileInputStream fin = new FileInputStream("list.ser");
            ois = new ObjectInputStream(fin);

            // Downcast!
            ArrayList<String> list = (ArrayList<String>) ois.readObject();

            System.out.println("Deserializing successfully completed");
            System.out.println(list.toString());

        } catch (ClassNotFoundException e) { // !!!
            System.out.println(
                    "The class for this type of objects does "
                    + "not exist in this application!");
            throw e;
        } finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            } catch (IOException e) {
            }
        }
    }
}
