
/**
 * Output text with a FileWriter.
 */
import java.io.*;

public class WriteChar {

    public static void main(String[] args) {

        // args[0] - name of output file
        if (args.length != 1) {
            System.out.println("Usage: java WriteChar filename");
            System.exit(0);
        }

        FileWriter fout = null;

        try {
            fout = new FileWriter(args[0]);

            String s = "This text should appear in the file.";
            char[] chars = s.toCharArray();
            fout.write(chars);

            System.out.println("Done.");
        } catch (IOException ie) {
            // Ugly... This is just an example to show where the code
            // handling an exception goes, if any. If you can't handle 
            // the exception, do NOT write a catch block - "do not nail
            // your corpse in the upright position".
        } finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            } catch (IOException e) {
            }
        }
    }
}
