// file: Save.java
// How to serialize java objects to a file

import java.io.*;
import java.util.*;

public class Save {

    public static void main(String[] args) throws IOException {

        ArrayList<String> list = new ArrayList<>();
        list.add("Led Zeppelin");
        list.add("Deep Purple");
        list.add("Black Sabbath");

        ObjectOutputStream oos = null;

        try {
            FileOutputStream fout = new FileOutputStream("list.ser");
            oos = new ObjectOutputStream(fout);

            oos.writeObject(list);

            System.out.println("Serializing successfully completed");
        } finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            } catch (IOException e) {
            }
        }
    }
}
