
/**
 * Student extends Person, i.e. Student is
 * a specialization and sub type of Person.
 *
 * Because inherited fields name and age are
 * private in super class Person, they can only
 * be referenced through public (or protected)
 * methods.
 */
public class Student extends Person {

    private String program;
    private int credits;

    public Student(String name, int age, String program, int credits) {
        super(name, age); // Call constructor in super class
        this.program = program;
        this.credits = credits;
    }

    public void addCredits(int newCredits) {
        if (newCredits > 0) {
            credits += newCredits;
        }
    }

    /* To reference inherited private fields name and age,
	 * use the public access methods (also inherited).
     */
    @Override
    public String toString() {
        String info = super.getName() + ", program  " + program;
        info += ", age  " + super.getAge() + ", " + credits + " credits";
        return info;
    }
}
