
/**
 * CreditAccount is a sub class to class Account,
 * i.e. the class inherits fields and methods from
 * the superclass.
 * The sub class may define new fields and members and
 * may override inherited methods.
 */
public class CreditAccount extends Account {

    // Inherited fields: balance, name
    protected double limit; // Credit limit

    public CreditAccount(String name, double limit) {
        super(name); // First, call a proper super constructor
        this.limit = limit;
    }

    public CreditAccount(String name, double balance, double limit) {
        super(name, balance); // First, call a proper super constructor
        this.limit = limit;
    }

    public double getCreditLimit() {
        return limit;
    }

    /* Because we now have a credit limit, we have to
	 * override the (inherited) method withdraw.
     */
    @Override
    public void withdraw(double amount) {
        if (amount > balance + limit) {
            System.out.println("Withdrawal not allowed!");
        } else {
            balance = balance - amount;
        }
    }

    /* toString is overridden to include information on the credit limit.
     */
    @Override
    public String toString() {
        // Call to the super version, to get info on balance and name
        String info = super.toString();
        info += ", credit limit: " + limit;
        return info;
    }
}
