
/**
 *   The super class Account
 *   The fields are declared to have the visibility
 *   "protected", i.e. they are accessible in sub
 *   classes (and classes in the same package),
 *   but are otherwise private.
 */

public class Account {

    // Protected fields
    protected double balance;
    protected String name;

    // Constructors
    public Account(String name, double balance) {
        this.name = name;
        this.balance = balance;
    }

    public Account(String name) {
        this.name = name;
        this.balance = 0.0;
    }

    // Accessors
    public double getBalance() {
        return balance;
    }

    public String getName() {
        return name;
    }

    // Mutators
    public void deposit(double amount) {
        if (amount < 0) {
            System.out.println("Deposit not allowed!");
        } else {
            balance += amount;
        }
    }

    public void withdraw(double amount) {
        if (amount > balance || amount < 0) {
            System.out.println("Withdrawal not allowed!");
        } else {
            balance -= amount;
        }
    }

    public String toString() {
        String info
                = "Name: " + name + ", balance = " + balance;
        return info;
    }
}
