package se.kth.anderslm.animationobjects;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

public class AnimationView extends View {

	public AnimationView(Context context, AttributeSet attrs) {
		super(context, attrs);

		// Represent the image as a Drawable
		Resources resources = context.getResources();
		cross = (Drawable) resources.getDrawable(R.drawable.cross);

		bounds = new Rect();
		paint = new Paint();
		paint.setColor(Color.WHITE);

		posx = this.getWidth() / 2;
		posy = this.getHeight() / 2;
	}

	public AnimationView(Context context) {
		this(context, null);
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		int action = event.getAction();
		switch (action) {
		case (MotionEvent.ACTION_DOWN):
		case (MotionEvent.ACTION_MOVE):
			posx = (int) event.getX();
			posy = (int) event.getY();
			invalidate();
			break;
		case (MotionEvent.ACTION_UP):
			// check position, update model, ...
			break;
		}
		Log.i("AnimationView.onTouchEvent", event.toString());
		return true;
	}

	@Override
	protected void onDraw(Canvas canvas) {
		// draw background
		int w = this.getWidth(), h = this.getHeight();
		canvas.drawRect(0, 0, w, h, paint);

		// draw cross
		int iw = cross.getIntrinsicWidth();
		int ih = cross.getIntrinsicHeight();
		bounds.set(posx - iw / 2, posy - ih / 2, posx + iw / 2, posy + ih / 2);
		cross.setBounds(bounds);
		cross.draw(canvas);
	}

	private Drawable cross;
	private Rect bounds;
	private Paint paint;
	
	private int posx, posy;
}
