package se.kth.anderslm.networking1;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;

public class NetActivity1 extends Activity {

	private final String urlString = "http://www.google.com";
	private final String fileName = "/images/srpr/logo11w.png";

	private ImageView imageView;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button downladButton = (Button) findViewById(R.id.DownloadButton);
		downladButton.setOnClickListener(new OnDownloadListener());

		imageView = (ImageView) findViewById(R.id.ImageView);
	}

	private class OnDownloadListener implements View.OnClickListener {

		public void onClick(View v) {
			try {
				downloadImage(urlString, fileName);
				showToast("Download completed");

			} catch (Exception e) {
				showToast("Error while downloading");
				Log.e("NetActivity1", "Error while downloading", e);
			}
		}
	}

	/*
	 * NB! This task might take some time - in a real application it must be
	 * executed in the background using a thread, an ASyncTask or similar.
	 */
	private void downloadImage(String urlStr, String fileName)
			throws IOException {

		HttpURLConnection http = null;
		InputStream istream = null;

		try {
			URL text = new URL(urlStr + fileName);
			http = (HttpURLConnection) text.openConnection();

			Log.i("NetActivity1", "length = " + http.getContentLength());
			Log.i("NetActivity1", "responseCode = " + http.getResponseCode());
			Log.i("NetActivity1", "contentType = " + http.getContentType());
			Log.i("NetActivity1", "content = " + http.getContent());

			istream = http.getInputStream();
			Bitmap bmImg = BitmapFactory.decodeStream(istream);
			imageView.setImageBitmap(bmImg);
		} finally {
			if (istream != null)
				istream.close();
			if (http != null)
				http.disconnect();
		}
	}

	private void showToast(String msg) {
		Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
		toast.show();
	}
}