package se.kth.anderslm.todolist2;

import java.util.ArrayList;

import se.kth.anderslm.todolist2.model.ToDoItem;

import android.os.Bundle;
import android.app.Activity;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListView;

public class MainActivity extends Activity {

	private ArrayList<ToDoItem> toDoItems;
	private ToDoArrayAdapter adapter;

	private EditText toDoInput;
	private ListView toDoListView;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		// Inflate the view from XML
		this.setContentView(R.layout.activity_main);

		// Get references to the user interface components
		toDoInput = (EditText) findViewById(R.id.ToDoInput);
		toDoListView = (ListView) findViewById(R.id.ToDoListView);

		// Create an ArrayList for the to-do-items
		toDoItems = new ArrayList<ToDoItem>();
		// Create an ArrayAdapter to bind the ListView to the data
		adapter = new ToDoArrayAdapter(this, toDoItems);
		toDoListView.setAdapter(adapter);

		// Register the ListView for this Activity's ContextMenu
		this.registerForContextMenu(toDoListView);
	}

	/**
	 * Overriding this Activity's onCreateOptionsMenu method. A ContextMenu for
	 * managing To-DoItems (remove)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.main_activity_actions, menu);
		return super.onCreateOptionsMenu(menu);
	}

	/**
	 * Overriding the Activity's onOptionsItemSelected method. This is where we
	 * define what actions to take when a option menu item is selected.
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {

		switch (item.getItemId()) {
		case R.id.action_add_todo:
			String text = toDoInput.getText().toString();
			toDoItems.add(new ToDoItem(text));
			adapter.notifyDataSetChanged(); // Update view via the adapter
			toDoInput.setText("");
			return true;
		case R.id.action_cancel:
			toDoInput.setText("");
			return true;
		default:
			// Other alternatives -> default behavior
			return super.onOptionsItemSelected(item);
		}
	}

	/**
	 * Overriding this Activity's onCreateContextMenu method. A ContextMenu for
	 * managing To-Do-Items (remove)
	 */
	@Override
	public void onCreateContextMenu(ContextMenu menu, View view,
			ContextMenu.ContextMenuInfo menuInfo) {
		super.onCreateContextMenu(menu, view, menuInfo);
	    MenuInflater inflater = getMenuInflater();
	    inflater.inflate(R.menu.todolist_context_actions, menu);
	}

	/**
	 * Overriding the Activity's onContextItemSelected method. This is where we
	 * define what actions to take when a context menu item is selected.
	 */
	@Override
	public boolean onContextItemSelected(MenuItem item) {

		switch (item.getItemId()) {
		case R.id.action_remove_todo:
			AdapterView.AdapterContextMenuInfo menuInfo;
			menuInfo = (AdapterView.AdapterContextMenuInfo) item.getMenuInfo();
			int info = menuInfo.position;
			toDoItems.remove(info);
			adapter.notifyDataSetChanged(); // Update view via the adapter
			return true;
		case R.id.action_cancel:
			// Do nothing
			return true;
		default:
			// Other alternatives -> default behavior
			return super.onContextItemSelected(item);
		}
	}

}
